package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The Class Request.
 * 
 * Description: In this Request Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User_Approver Table in the
 * database.
 */
/**
 * @author Paramjeet Bindra
 *
 */
@Entity
@Table(name = "Request", schema = "dbo")
public class Request implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -8093827197557947619L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;

	/** The process id. */
	@JsonIgnore
	@Column(name = "ProcessId", nullable = false)
	private int processId;

	/** The title. */
	@Column(name = "Title", length = 256)
	private String title;

	/** The description. */
	@Column(name = "Description", length = 3000)
	private String description;

	/** The status description. */
	@Column(name = "StatusDescription", length = 50)
	private String statusDescription;

	/** The created on. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	private Date createdOn;

	/** The modified on. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	private Date modifiedOn;

	/** The created by. */
	@Column(name = "CreatedBy", length = 50)
	private String createdBy;

	/** The modified by. */
	@Column(name = "ModifiedBy", length = 50)
	private String modifiedBy;

	/** The approver id. */
	@Column(name = "ApproverId", length = 50)
	private String approverId;

	/** The task id. */
	@Column(name = "TaskId", length = 50)
	private String taskId;

	/** The request histories. */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "request")
	private Set<RequestHistory> requestHistories = new HashSet<>(0);

	/**
	 * The requestType ID for input and output Json Object
	 */
	@Column(name = "RequestTypeId", nullable = false, insertable = false, updatable = false)
	private int requestTypeId;

	/**
	 * The Request Type
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "RequestTypeId", nullable = false)
	private RequestType requestType;

	/**
	 * The studyApproval Id for input and output Json Object
	 */
	@Column(name = "StudyApprovalId", nullable = false, insertable = false, updatable = false)
	private int studyApprovalId;
	
	/**
	 * The Study Approval
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "StudyApprovalId", nullable = false)
	private StudyApproval studyApproval;

	/**
	 * The source Id for input and output Json Object
	 */
	@Column(name = "SourceId", nullable = false, insertable = false, updatable = false)
	private int sourceId;

	/**
	 * The source
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "SourceId", nullable = false)
	private Source source;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the process id.
	 *
	 * @return the process id
	 */
	public int getProcessId() {
		return this.processId;
	}

	/**
	 * Sets the process id.
	 *
	 * @param processId
	 *            the new process id
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * Gets the title.
	 *
	 * @return the title
	 */
	public String getTitle() {
		return this.title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title
	 *            the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the status description.
	 *
	 * @return the status description
	 */
	public String getStatusDescription() {
		return this.statusDescription;
	}

	/**
	 * Sets the status description.
	 *
	 * @param statusDescription
	 *            the new status description
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/**
	 * Gets the request type.
	 *
	 * @return the request type
	 */
	public RequestType getRequestType() {
		return this.requestType;
	}

	/**
	 * Sets the request type.
	 *
	 * @param requestType
	 *            the new request type
	 */
	public void setRequestType(RequestType requestType) {
		this.requestType = requestType;
	}

	public StudyApproval getStudyApproval() {
		return this.studyApproval;
	}

	public void setStudyApproval(StudyApproval studyApproval) {
		this.studyApproval = studyApproval;
	}

	public Source getSource() {
		return this.source;
	}

	public void setSource(Source source) {
		this.source = source;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn
	 *            the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the modified on.
	 *
	 * @return the modified on
	 */
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	/**
	 * Sets the modified on.
	 *
	 * @param modifiedOn
	 *            the new modified on
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy
	 *            the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the modified by.
	 *
	 * @return the modified by
	 */
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	/**
	 * Sets the modified by.
	 *
	 * @param modifiedBy
	 *            the new modified by
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description
	 *            the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the approver id.
	 *
	 * @return the approver id
	 */
	public String getApproverId() {
		return approverId;
	}

	/**
	 * Sets the approver id.
	 *
	 * @param approverId
	 *            the new approver id
	 */
	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	/**
	 * Gets the task id.
	 *
	 * @return the task id
	 */
	public String getTaskId() {
		return this.taskId;
	}

	/**
	 * Sets the task id.
	 *
	 * @param taskId
	 *            the new task id
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	/**
	 * Gets the request histories.
	 *
	 * @return the request histories
	 */
	public Set<RequestHistory> getRequestHistories() {
		return this.requestHistories;
	}

	public void setRequestHistories(Set<RequestHistory> requestHistories) {
		this.requestHistories = requestHistories;
	}

	/**
	 * @return the sourceId
	 */
	@Transient
	public int getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId
	 *            the sourceId to set
	 */
	public void setSourceId(int sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * @return the requestTypeId
	 */
	public int getRequestTypeId() {
		return requestTypeId;
	}

	/**
	 * @param requestTypeId
	 *            the requestTypeId to set
	 */
	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}

	/**
	 * @return the studyApprovalId
	 */
	public int getStudyApprovalId() {
		return studyApprovalId;
	}

	/**
	 * @param studyApprovalId
	 *            the studyApprovalId to set
	 */
	public void setStudyApprovalId(int studyApprovalId) {
		this.studyApprovalId = studyApprovalId;
	}
}
